/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Graphics;
import jclass.chart.JCChart;
import jclass.chart.JCStyle;

public class JCLineStyle
extends JCStyle {
    int pattern = 1;
    int width = 1;
    Color color;
    static int defaultColorIndex;
    static int defaultPattern;
    public static final int NONE = 0;
    public static final int SOLID = 1;
    public static final int LONG_DASH = 2;
    public static final int SHORT_DASH = 3;
    public static final int LSL_DASH = 4;
    public static final int DASH_DOT = 5;

    public JCLineStyle(int n, Color color, int n2) {
        this.width = n;
        this.color = color;
        this.pattern = n2;
    }

    public static JCLineStyle makeDefault(JCChart jCChart) {
        return new JCLineStyle(1, JCLineStyle.getDefaultColor(jCChart), JCLineStyle.getDefaultPattern());
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.pattern == 0 || this.width <= 0) {
            return;
        }
        if (graphics.getColor() != this.color) {
            graphics.setColor(this.color);
        }
        graphics.drawLine(n, n2, n3, n4);
    }

    public int getPattern() {
        return this.pattern;
    }

    public synchronized void setPattern(int n) {
        if (n == this.pattern) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.pattern = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for Patter in JCLineStyle.  Should be one of NONE, SOLID, LONG_DASH, SHORT_DASH, LSL_DASH or DASH_DOT");
            }
        }
        this.setChanged(true);
    }

    public int getWidth() {
        return this.width;
    }

    public synchronized void setWidth(int n) {
        if (this.width == n) {
            return;
        }
        this.width = n;
        this.setChanged(true);
    }

    public Color getColor() {
        return this.color;
    }

    public synchronized void setColor(Color color) {
        if (this.color == color) {
            return;
        }
        this.color = color;
        this.setChanged(true);
    }

    static Color getDefaultColor(JCChart jCChart) {
        Color color = JCStyle.defaultColors[defaultColorIndex++];
        if (jCChart != null && jCChart.chartArea != null && color == jCChart.chartArea.getPlotArea().getBackground()) {
            color = JCStyle.defaultColors[defaultColorIndex++];
        }
        if (defaultColorIndex >= JCStyle.defaultColors.length) {
            defaultColorIndex = 0;
        }
        return color;
    }

    static int getDefaultPattern() {
        int n = defaultPattern++;
        if (defaultPattern > 5) {
            defaultPattern = 1;
        }
        return n;
    }

    static {
        defaultPattern = 1;
    }
}

